<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $property['title'] }}</title>

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="{{ $property['title'] }}" />
    <meta property="og:description" content="{{ $property['bedroom'] }} | {{ $property['area'] }} | {{ $property['price'] }}" />
    <meta property="og:image" content="{{ $property['imagePaths'][0] }}" />
    <meta property="og:url" content="{{ url()->current() }}" />
    <meta property="og:type" content="website" />

    <!-- Optional: Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="{{ $property['title'] }}" />
    <meta name="twitter:description" content="{{ $property['bedroom'] }} | {{ $property['area'] }} | {{ $property['price'] }}" />
    <meta name="twitter:image" content="{{ $property['imagePaths'][0] }}" />
</head>
<body>
    <h1>{{ $property['title'] }}</h1>
    <p>{{ $property['bedroom'] }} | {{ $property['area'] }} | {{ $property['price'] }}</p>
    <img src="{{ $property['imagePaths'][0] }}" alt="Property Image" style="max-width: 100%; height: auto;">
</body>
</html>